<!-- Main content -->
<x-admin.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuOpen>{{ $data['menuOpen'] }} </x-slot:menuOpen>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:page>{{ $data['page'] }}</x-slot:page>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('') }}assets/plugins/sweetalert2/sweetalert2.min.css">
        <style>
            .informasi {
                background-color: rgb(245, 245, 227);
                padding: 15px;
                border-radius: 10px;
                font-size: 12px;
            }
        </style>
    </x-slot:head>


    <section class="content">

        <!-- Default box -->
        <div class="row">
            <div class="col-lg-12">
                <x-message></x-message>
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <button class="btn btn-success float-right mb-3" data-toggle="modal" data-target="#tambah"><i
                                class="fa fa-plus-circle mr-2"></i> Banner
                            Baru</button>
                        <h3 class="card-title"><i class="fa fa-server text-primary"></i> {{ $data['page'] }}</h3>
                    </div>
                    <div class="card-body">

                        <table class="table table-bordered table-hover myTable tab">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="8%">Gambar</th>
                                    <th>Judul</th>
                                    <th>Link</th>
                                    <th>Status</th>
                                    <th width="15%">Tgl. Input</th>
                                    <th width="20%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view">
                                @forelse ($slid as $s)
                                    <tr>
                                        <td class="text-center">{{ $no++ }}</td>
                                        <td class="text-center">
                                            <img src="{{ asset('/storage/banner/' . $s->gambar) }}" alt=" banner"
                                                class="table-avatar" width="100px">
                                        </td>
                                        <td>{{ $s->judul }}</td>
                                        <td>{{ $s->link }}</td>
                                        <td>
                                            <div class="custom-control custom-switch   custom-switch-on-success">
                                                <input type="checkbox" class="custom-control-input check"
                                                    data-id="{{ $s->id }}" data-v="{{ $s->status }}"
                                                    {{ $s->status == 'Y' ? 'checked' : '' }}
                                                    id="status{{ $s->id }}">
                                                <label class="custom-control-label" for="status{{ $s->id }}">
                                                    {{ $s->status == 'Y' ? 'Aktif' : 'Tidak Aktif' }}</label>
                                            </div>

                                        </td>
                                        <td>{{ tgl_inf($s->updated_at) }}</td>
                                        <td class="text-center">
                                            <button class="btn btn-primary btn-sm" data-toggle="modal"
                                                data-target="#edit{{ $s->id }}"><i class="fa fa-edit mr-2"></i>
                                                Edit</button>
                                            <button class="btn btn-info btn-sm detail" data-id="{{ $s->id }}"><i
                                                    class="fa fa-search mr-2"></i>
                                                Detail</button>
                                            <button class="btn btn-danger btn-sm hapus" data-id="{{ $s->id }}"
                                                data-nm="{{ $s->judul }}"><i class="fa fa-trash mr-2"></i>
                                                Hapus</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="12" class="text-center">Data masih kosong</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-lg-12">
                <hr>
            </div>

            <div class="col-lg-12">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title "><i class="fa fa-server text-primary"></i> Banner Atas
                        </h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover myTable tab">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="8%">Gambar</th>
                                    <th>Judul</th>
                                    <th>Isi</th>
                                    <th>Link</th>
                                    <th width="20%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view2">
                                @php
                                    $i = 1;
                                @endphp
                                @forelse ($ban_atas as $b)
                                    <tr>
                                        <td class="text-center">{{ $i++ }}</td>
                                        <td class="text-center">
                                            <img src="{{ asset('/storage/banner/' . $b->gambar) }}" alt=" banner"
                                                class="table-avatar" width="100px">
                                        </td>
                                        <td>{{ $b->judul }}</td>
                                        <td>{{ $b->isi }}</td>
                                        <td>{{ $b->link }}</td>
                                        <td class="text-center">
                                            <button class="btn btn-primary btn-sm" data-toggle="modal"
                                                data-target="#edit{{ $b->id }}"><i class="fa fa-edit mr-2"></i>
                                                Edit</button>
                                            <button class="btn btn-info btn-sm detail" data-id="{{ $b->id }}"><i
                                                    class="fa fa-search mr-2"></i>
                                                Detail</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="12" class="text-center">Data masih kosong</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-lg-12">
                <hr>
            </div>

            <div class="col-lg-12">
                <div class="card card-primary card-outline">
                    <div class="card-header">
                        <h3 class="card-title "><i class="fa fa-server text-primary"></i> Banner Bawah
                        </h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-bordered table-hover myTable tab">
                            <thead>
                                <tr>
                                    <th width="5%">No</th>
                                    <th width="8%">Gambar</th>
                                    <th>Judul</th>
                                    <th>Isi</th>
                                    <th>Link</th>
                                    <th width="20%">Opsi</th>
                                </tr>
                            </thead>
                            <tbody id="view3">
                                @php
                                    $r = 1;
                                @endphp
                                @forelse ($ban_bawah as $b)
                                    <tr>
                                        <td class="text-center">{{ $r++ }}</td>
                                        <td class="text-center">
                                            <img src="{{ asset('/storage/banner/' . $b->gambar) }}" alt=" banner"
                                                class="table-avatar" width="100px">
                                        </td>
                                        <td>{{ $b->judul }}</td>
                                        <td>{{ $b->isi }}</td>
                                        <td>{{ $b->link }}</td>
                                        <td class="text-center">
                                            <button class="btn btn-primary btn-sm" data-toggle="modal"
                                                data-target="#edit{{ $b->id }}"><i class="fa fa-edit mr-2"></i>
                                                Edit</button>
                                            <button class="btn btn-info btn-sm detail"
                                                data-id="{{ $b->id }}"><i class="fa fa-search mr-2"></i>
                                                Detail</button>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="12" class="text-center">Data masih kosong</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>


        </div>
        <!-- /.card -->

    </section>

    {{-- tambah Banner --}}
    <div class="modal fade" id="tambah">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header bg-primary ">
                    Tambah Data Banner
                </div>
                <form action="{{ route('banner.tambah') }}" method="post" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="kode" id="" value="BNS">
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="">Judul</label>
                            <input type="text" name="judul" class="form-control" placeholder="Judul..."
                                required>
                        </div>
                        <div class="form-group">
                            <label for="">Isi Keterangan</label>
                            <textarea name="isi" id="isi" class="form-control" required></textarea>
                        </div>
                        <div class="form-group">
                            <label for="">Link Produk</label>
                            <input type="text" name="link" class="form-control" placeholder="link..."
                                required>
                        </div>
                        <div class="form-group">
                            <label for="">Gambar</label>
                            <div class="custom-file">
                                <input type="file" name="gambar" class="custom-file-input" id="exampleInputFile"
                                    required>
                                <label class="custom-file-label" for="exampleInputFile">Cari
                                    Gambar</label>
                            </div>
                        </div>

                        <div class="d-flex justify-content-center">
                            <div style="height: 180px; width: 50%; border:1px solid  #eaedf0" class="gambar"></div>
                        </div>
                    </div>
                    <div class="modal-footer justify-content-between">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary satuan"><i class="fa fa-save mr-2"></i>
                            Simpan</button>
                    </div>
                </form>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>


    @foreach ($banner as $b)
        <div class="modal fade" id="edit{{ $b->id }}">
            <div class="modal-dialog modal-lg">
                <div class="modal-content">
                    <div class="modal-header bg-primary ">
                        Edit Data Banner
                    </div>
                    <form action="{{ route('banner.edit') }}" method="post" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="id" id="" value="{{ $b->id }}">
                        <input type="hidden" name="gbrlama" id="" value="{{ $b->gambar }}">
                        <div class="modal-body">
                            <div class="form-group">
                                <label for="">Judul</label>
                                <input type="text" name="judul" class="form-control" placeholder="Judul..."
                                    required value="{{ $b->judul }}">
                            </div>
                            <div class="form-group">
                                <label for="">Isi Keterangan</label>
                                <textarea name="isi" id="isi" class="form-control" required>{{ $b->isi }}</textarea>
                            </div>
                            <div class="form-group">
                                <label for="">Link Produk</label>
                                <input type="text" name="link" class="form-control" placeholder="link..."
                                    required value="{{ $b->link }}">
                            </div>
                            <div class="form-group">
                                <label for="">Gambar</label>
                                <div class="custom-file">
                                    <input type="file" name="gambar" class="custom-file-input imeg"
                                        id="exampleInputFile">
                                    <label class="custom-file-label" for="exampleInputFile">Cari
                                        Gambar</label>
                                </div>
                            </div>

                            <div class="d-flex justify-content-center">
                                <div style="height: 180px; width: 50%; border:1px solid  #eaedf0" class="gambar">
                                    <img src="{{ asset('/storage/banner/' . $b->gambar) }}" alt="banner"
                                        class="vgmb" height="220px" width="100%">
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer justify-content-between">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn btn-primary satuan"><i class="fa fa-save mr-2"></i>
                                Simpan</button>
                        </div>
                    </form>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
    @endforeach

    {{-- Detail Banner --}}
    <div class="modal fade" id="mdetail">
        <div class="modal-dialog ">
            <div class="modal-content">
                <div class="modal-header bg-primary ">
                    Detail Data Banner
                </div>
                <div class="modal-body" id="vdetail">

                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/bs-custom-file-input/bs-custom-file-input.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            $(function() {
                bsCustomFileInput.init();

                $("#exampleInputFile").change(function() {
                    filePreview(this);
                });

                $(".imeg").change(function() {
                    filePreview(this);
                });

                function filePreview(input) {
                    if (input.files && input.files[0]) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            $('#img').remove();
                            $('.vgmb').hide();
                            $('.gambar').append('<img src="' + e.target.result +
                                '" width="100%" height="180px" id="img">');
                        };
                        reader.readAsDataURL(input.files[0]);
                    }
                }

                $('#view').on('click', '.check', function() {
                    var token = $("meta[name='csrf-token']").attr("content");
                    var id = $(this).attr('data-id');
                    var value = $(this).attr('data-v');
                    if (value == "Y") {
                        var isi = "N";
                    } else {
                        var isi = "Y";
                    }
                    $.ajax({
                        type: 'POST',
                        url: 'status-banner',
                        data: {
                            id: id,
                            isi: isi,
                            _token: token,
                        },
                        success: function(data) {
                            document.location.href = "";
                        }
                    });
                });

                $('#view').on('click', '.detail', function() {
                    var token = $("meta[name='csrf-token']").attr("content");
                    var id = $(this).attr('data-id');
                    $.ajax({
                        type: 'POST',
                        url: 'detail-banner',
                        data: {
                            id: id,
                            _token: token,
                        },
                        success: function(data) {
                            $('#mdetail').modal('show');
                            $('#vdetail').html(data);
                        }
                    });
                });

                $('#view').on('click', '.hapus', function() {
                    var id = $(this).attr('data-id');
                    var nama = $(this).attr('data-nm');

                    Swal.fire({
                        title: "Apa anda yakin?",
                        text: "Banner dengan Judul ( " + nama + " ) akan di hapus!",
                        icon: "warning",
                        showCancelButton: true,
                        confirmButtonColor: "#3085d6",
                        cancelButtonColor: "#d33",
                        confirmButtonText: "Ya, Hapus!"
                    }).then((result) => {
                        if (result.isConfirmed) {
                            document.location.href = "delete-banner/" + id;
                        }
                    });

                });

                $('#view2').on('click', '.detail', function() {
                    var token = $("meta[name='csrf-token']").attr("content");
                    var id = $(this).attr('data-id');
                    $.ajax({
                        type: 'POST',
                        url: 'detail-banner',
                        data: {
                            id: id,
                            _token: token,
                        },
                        success: function(data) {
                            $('#mdetail').modal('show');
                            $('#vdetail').html(data);
                        }
                    });
                });

                $('#view3').on('click', '.detail', function() {
                    var token = $("meta[name='csrf-token']").attr("content");
                    var id = $(this).attr('data-id');
                    $.ajax({
                        type: 'POST',
                        url: 'detail-banner',
                        data: {
                            id: id,
                            _token: token,
                        },
                        success: function(data) {
                            $('#mdetail').modal('show');
                            $('#vdetail').html(data);
                        }
                    });
                });
            });
        </script>
    </x-slot:foot>
</x-admin.contents>
